var
	bUpdating: boolean;
	vLastResult: Variant;
	IVA1, IVA2, IVA3, RE1, RE2, RE3, IRPF, TOTAL: double;
	ADOQueryFromDetail, ADOQueryFromPlazos, ADOQueryToMaster, ADOQueryToDetail, ADOQueryToPlazos, pQueryStock, pQTPV:TFDQuery;
	

function FindField(ds: TDataSet; sFieldName: string):boolean;
var
	i: integer;
begin
	result:= false;
	
	for i:=0 to ds.FieldCount-1 do
	  if ds.Fields[i].FieldName = sFieldName then
		result:= true;
		
end;

procedure FillInDataSet(pO, pD: TDataSet; sFieldIgnore: string);
var
	i: integer;
begin
	for i:=0 to pD.FieldCount-1 do
		if FindField(pO, pD.Fields[i].FieldName) and not(Pos(pD.Fields[i].FieldName, sFieldIgnore)>0) and not(pD.Fields[i] is TAutoIncField) then
		begin
			//showmessage(pD.Fields[i].FieldName);
			pD.Fields[i].Value := pO.FieldByName(pD.Fields[i].FieldName).Value;
			
		end;
end;

function ParseQuery(sQuery: String):String;
begin
	Result:=zReplace(sQuery, '''', '''''');
end;

procedure ShowRecord(ds: TDataSet);
var
	i: integer;
	s: string;
begin
			s:='';
			
			for i:= 0 to ds.FieldCount-1 do
				s:=s+ds.Fields[i].AsString + #13+#10;
				
			ShowMessage(s);
end;

// SERIE
function GetSerie(sIDP: string):string;
var
		plSeries:TStringList;
		sSerie:string;
		i:integer;
begin
	plSeries := TStringList.Create();
	plSeries.Text := QueryConfiguracion.FieldByName('Series').AsString;

	for i := 0 to plSeries.Count-1 do
		if Pos(plSeries.Strings[i], sIDP) > 0 then
			sSerie := plSeries.Strings[i];

	plSeries.Free;


	Result:= sSerie;

end;

procedure CalcularPlazos(sKeyTo, sNumero: string);
var
  sKey: String;
  nDiaPago, nDias1, nDiasN, nRecibos, nNuevaPosicion, i: integer;
  dTotal, dRecibosPagados, dParcial, dCentimo: double;
  d, LastMonthDay: TDateTime;
  Year, Month, Day, LastDay, nMaxDay: Word;
begin
	if FindField(ADOQueryToMaster, 'ID_INGRESOS_PROGRAMADOS') then exit;
	
    if (ADOQueryToMaster.FieldByName('TOTAL').AsFloat = 0) or
       (ADOQueryToMaster.FieldByName('ID_FORMAS_PAGO').AsString = '')
    then
		  exit;

	Query.SQL.Text := 'SELECT * FROM FORMAS_PAGO WHERE ID_FORMAS_PAGO = ''' + ADOQueryToMaster.FieldByName('ID_FORMAS_PAGO').AsString + '''';
	  Query.Active := true;
	  
	nRecibos := Query.FieldByName('NumeroRecibos').AsInteger;
	nDias1 := Query.FieldByName('PrimerRecibo').AsInteger;
	nDiasN := Query.FieldByName('RestoRecibos').AsInteger;

	
	
    if FindField(ADOQueryToMaster, 'ID_CLIENTES') then
	begin
		sKey := 'ID_CLIENTES';
		Query.SQL.Text := 'SELECT * FROM CLIENTES WHERE ' + sKey + ' = ''' + ADOQueryToMaster.FieldByName(sKey).AsString + '''';
	end
	else
	begin
		sKey := 'ID_PROVEEDORES';
		Query.SQL.Text := 'SELECT * FROM PROVEEDORES WHERE ' + sKey + ' = ''' + ADOQueryToMaster.FieldByName(sKey).AsString + '''';
	end;
	
	Query.Active := true;
	  //DataSourcePartner.DataSet.Locate(sKey, ADOQueryToMaster.FieldByName(sKey).Text, []);

	  nDiaPago := Query.FieldByName('DiaPago').AsInteger; 

	
    //ADOQueryToPlazos := TClientDataSet(DataSourcePlazos.DataSet);
    //ADOQueryToPlazos.DisableControls();

    dTotal := ADOQueryToMaster.FieldByName('TOTAL').AsFloat;
    dRecibosPagados := 0;
		

    nNuevaPosicion := 1;

    ADOQueryToPlazos.First();
	
	//ShowMessage(ADOQueryToMaster.FieldByName('TOTAL').AsFloat);
	
	if (ADOQueryToPlazos.Eof) and (ADOQueryToMaster.FieldByName('Pagado').AsBoolean) then 
		dRecibosPagados := dTotal;
	
    while not ADOQueryToPlazos.Eof do
    begin
        if ADOQueryToPlazos.FieldByName('Pagado').AsBoolean then
        begin
            dRecibosPagados := dRecibosPagados + ADOQueryToPlazos.FieldByName('Importe').AsFloat;
        end;

        ADOQueryToPlazos.Next();
    end;
		
    // Borrar ahora para que no descuadre
    ADOQueryToPlazos.First();
    while not ADOQueryToPlazos.Eof do
        if ADOQueryToPlazos.FieldByName('Pagado').AsBoolean then
            ADOQueryToPlazos.Next()
        else
            ADOQueryToPlazos.Delete();



    dParcial := StrToFloat(FormatFloat('#0.##', (dTotal - dRecibosPagados) / nRecibos));

    dCentimo := (dTotal - dRecibosPagados) - dParcial * nRecibos;

	if dParcial <> 0 then
    for i := 1 to nRecibos do
    begin
        ADOQueryToPlazos.Insert();

		ADOQueryToPlazos.FieldByName(sKeyTo).AsString := sNumero;
		
		ADOQueryToPlazos.FieldByName('Posicion').AsInteger := nNuevaPosicion;

		nNuevaPosicion:= nNuevaPosicion + 1;

		ADOQueryToPlazos.FieldByName('Pagado').AsBoolean := ADOQueryToMaster.FieldByName('Pagado').AsBoolean;


		if i = 1 then
		  d := ADOQueryToMaster.FieldByName('Fecha').AsDateTime + nDias1
		else
			d := ADOQueryToMaster.FieldByName('Fecha').AsDateTime + nDias1 + nDiasN * (i - 1);


		if nDiaPago <> 0 then
		begin
			
			DecodeDate(d, Year, Month, Day);
			LastDay := DaysInMonth(Year, Month);

			//DecodeDate(LastMonthDay, Year, Month, LastDay);
			DecodeDate(d, Year, Month, Day);

			// Determinar que no se facture un 30 de febrero ...
			if nDiaPago > LastDay then
				nMaxDay := LastDay
			else
				nMaxDay := nDiaPago;

			while nMaxDay <> Day do
			begin

				d := d + 1;
				DecodeDate(d, Year, Month, Day);
			end;

		end;

		ADOQueryToPlazos.FieldByName('Fecha').AsDateTime := d ;

		ADOQueryToPlazos.FieldByName('Concepto').AsString := Format(QueryConfiguracion.FieldByName('Plazo').AsString, [IntToStr(i), ADOQueryToMaster.Fields[0].AsString]);
			//'Vencimiento Nº ' + String(i) + ' del documento ' + DBEditNumero.Text;

		ADOQueryToPlazos.FieldByName('Importe').AsString := FormatFloat('#0.##', dParcial + dCentimo);

		dCentimo := 0;

		ADOQueryToPlazos.Post();
    end;
	
	ADOQueryToMaster.Edit;
	ADOQueryToMaster.FieldByName('TotalPendiente').AsFloat := zRound(ADOQueryToMaster.FieldByName('TOTAL').AsFloat - dRecibosPagados);
	
	ADOQueryToMaster.FieldByName('Pagado').AsBoolean := (ADOQueryToMaster.FieldByName('TotalPendiente').AsFloat = 0);
	ADOQueryToMaster.Post;
    //ADOQueryToPlazos.EnableControls();


end;

function CalcularPrecios(sField: String):double;
var
   dBases, dIVAs, dREs:array[1..3] of double;
   nCantidad, dPrecio, dDescuento, dIva, dIRPF, dCoeficiente: double;
   IdIva, f: integer;
   bExiste: boolean;
   bm: string;
begin

  IdIva := 0;
  bExiste := false;
  for f := 1 to 3 do
  begin
       dBases[f] := 0;
       dIVAs[f] := 0;
       dREs[f] := 0;
  end;
  

  
	ADOQueryToMaster.Edit;
	ADOQueryToMaster.FieldByName('BaseImponible1').AsString := '';
	ADOQueryToMaster.FieldByName('BaseImponible2').AsString := '';
	ADOQueryToMaster.FieldByName('BaseImponible3').AsString := '';
	ADOQueryToMaster.FieldByName('IVA1').AsString := '';
	ADOQueryToMaster.FieldByName('IVA2').AsString := '';
	ADOQueryToMaster.FieldByName('IVA3').AsString := '';
	ADOQueryToMaster.FieldByName('RE1').AsString := '';
	ADOQueryToMaster.FieldByName('RE2').AsString := '';
	ADOQueryToMaster.FieldByName('RE3').AsString := '';
	
	ADOQueryToMaster.FieldByName('TotalDescuento').AsString := '';
	
	ADOQueryToMaster.FieldByName('TotalIVA1').AsString := '';
	ADOQueryToMaster.FieldByName('TotalIVA2').AsString := '';
	ADOQueryToMaster.FieldByName('TotalIVA3').AsString := '';
	
	ADOQueryToMaster.FieldByName('TotalRE1').AsString := '';
	ADOQueryToMaster.FieldByName('TotalRE2').AsString := '';
	ADOQueryToMaster.FieldByName('TotalRE3').AsString := '';
	
	ADOQueryToMaster.FieldByName('TotalIRPF').AsString := '';
	
	ADOQueryToMaster.FieldByName('TOTAL').AsString := '';

	if (ADOQueryToDetail.Eof) and (ADOQueryToDetail.Bof) then exit;
	
	bm := ADOQueryToDetail.Fields[0].AsString;
	ADOQueryToDetail.DisableControls();
	
	ADOQueryToDetail.First;

	while not ADOQueryToDetail.Eof do
	begin

		
		
      nCantidad := ADOQueryToDetail.FieldByName('Cantidad').AsFloat;
      dPrecio := zRound(ADOQueryToDetail.FieldByName('Precio').AsFloat, QueryConfiguracion.FieldByName('DecimalesMoneda').AsInteger);
      dDescuento := ADOQueryToDetail.FieldByName('Descuento').AsFloat;
      dIva := ADOQueryToDetail.FieldByName('IVA').AsFloat;
	  
	  {dCoeficiente := 1;	  
	  if FindField(ADOQueryToDetail, 'Coeficiente') then
		dCoeficiente := ADOQueryToDetail.FieldByName('Coeficiente').AsFloat;}

      if (nCantidad = 0)  then
        begin
            ADOQueryToDetail.Next;
            continue;
        end;
		
	 
	
	 ADOQueryToDetail.Edit;
	 if sField = 'Importe' then
	 begin		
		ADOQueryToDetail.FieldByName('Precio').AsFloat := zRound(ADOQueryToDetail.FieldByName('Importe').AsFloat / nCantidad / (dIVA/100 + 1) ) / (1 - dDescuento/100);
	 end
	 else
		ADOQueryToDetail.FieldByName('Importe').AsFloat := zRound(nCantidad * ( dPrecio * (100 - dDescuento ) / 100 )) * ((dIVA/100 + 1));	

      // Para cada tipo de IVA
      if ( IdIva = 0 ) then
      begin
           IdIva := IdIva + 1;

            dIVAs[IdIva] := dIva;
            dBases[IdIva] := dBases[IdIva] + zRound(nCantidad * ( dPrecio * (100 - dDescuento ) / 100 ));


      end
      else
      begin
            // Recorrer todos los IVAS para ver si ya estÃ¡ en la lista
            bExiste := false;
            for f := 1 to IdIva do
            begin
                if ( dIVAs[f] = dIva ) then
                begin
                    dBases[f] := dBases[f] + zRound( nCantidad * ( dPrecio * (100 - dDescuento ) / 100 ));
                    bExiste := true;
                end;
            end;
            if ( not bExiste ) then  // Nuevo tipo de iva
            begin
                 IdIva := IdIva + 1;
				 
				 if idIVA > 3 then		 
					idIVA := 3;
				 

                dIVAs[IdIva] := dIva;
                dBases[IdIva] := dBases[IdIva] + zRound( nCantidad * ( dPrecio * (100 - dDescuento ) / 100 ));


            end;
      end;


	ADOQueryToDetail.Next;

	end;
	
	
	if bm <> '' then	
		ADOQueryToDetail.Locate(ADOQueryToDetail.Fields[0].FieldName, bm, loCaseInsensitive);	
	
	ADOQueryToDetail.EnableControls();
	
	



	// DESCUENTO GENERAL
	for f := 1 to IdIva do
    begin

        dDescuento := (ADOQueryToMaster.FieldByName('Descuento').AsFloat / 100);


		dDescuento := zRound(dDescuento * dBases[f]);

		dBases[f] := dBases[f] - dDescuento;

		dBases[f] := zRound(dBases[f]);


    end;


	// BASES E IVA, RE
    ADOQueryToMaster.Edit;
    for f := 1 to IdIva do
    begin
         ADOQueryToMaster.FieldByName('BaseImponible' + IntToStr(f)).AsFloat := dBases[f];
         ADOQueryToMaster.FieldByName('IVA' + IntToStr(f)).AsFloat := dIVAs[f];
		 

		 if ADOQueryToMaster.FieldByName('ConRE').AsBoolean then
		 begin
			if dIVAs[f] = QueryConfiguracion.FieldByName('IVAGeneral').AsFloat then
                ADOQueryToMaster.FieldByName('RE' + IntToStr(f)).AsFloat := QueryConfiguracion.FieldByName('REGeneral').AsFloat
			else
			if dIVAs[f] = QueryConfiguracion.FieldByName('IVAReducido').AsFloat then
                ADOQueryToMaster.FieldByName('RE' + IntToStr(f)).AsFloat := QueryConfiguracion.FieldByName('REReducido').AsFloat
			else
			if dIVAs[f] = QueryConfiguracion.FieldByName('IVASuperReducido').AsFloat then
                ADOQueryToMaster.FieldByName('RE' + IntToStr(f)).AsFloat := QueryConfiguracion.FieldByName('RESuperReducido').AsFloat;
		 end;

    end;
    //ADOQueryToMaster.Post;

		//
		
    IVA1 := zRound(ADOQueryToMaster.FieldByName('BaseImponible1').AsFloat * ADOQueryToMaster.FieldByName('IVA1').AsFloat/100);
    IVA2 := zRound(ADOQueryToMaster.FieldByName('BaseImponible2').AsFloat * ADOQueryToMaster.FieldByName('IVA2').AsFloat/100);
    IVA3 := zRound(ADOQueryToMaster.FieldByName('BaseImponible3').AsFloat * ADOQueryToMaster.FieldByName('IVA3').AsFloat/100);

    RE1 := zRound(ADOQueryToMaster.FieldByName('BaseImponible1').AsFloat * ADOQueryToMaster.FieldByName('RE1').AsFloat/100);
    RE2 := zRound(ADOQueryToMaster.FieldByName('BaseImponible2').AsFloat * ADOQueryToMaster.FieldByName('RE2').AsFloat/100);
    RE3 := zRound(ADOQueryToMaster.FieldByName('BaseImponible3').AsFloat * ADOQueryToMaster.FieldByName('RE3').AsFloat/100);

	IRPF := 0;
    if ADOQueryToMaster.FieldByName('ConIRPF').AsBoolean then
	begin
		IRPF := ADOQueryToMaster.FieldByName('BaseImponible1').AsFloat + ADOQueryToMaster.FieldByName('BaseImponible2').AsFloat + ADOQueryToMaster.FieldByName('BaseImponible3').AsFloat;
		
		if QueryConfiguracion.FieldByName('CalcularIRPFGlobal').AsBoolean then
				IRPF := IRPF + IVA1 + IVA2 + IVA3;
				
		IRPF := zRound(ADOQueryToMaster.FieldByName('IRPF').AsFloat / 100 * (IRPF));
		 
	end
	else
		ADOQueryToMaster.FieldByName('IRPF').AsFloat := 0;


	TOTAL :=
		ADOQueryToMaster.FieldByName('BaseImponible1').AsFloat+
		ADOQueryToMaster.FieldByName('BaseImponible2').AsFloat+
		ADOQueryToMaster.FieldByName('BaseImponible3').AsFloat+
		IVA1+IVA2+IVA3+
		RE1+RE2+RE3
		-
		IRPF;
		
		
	if dDescuento <> 0 then
	ADOQueryToMaster.FieldByName('TotalDescuento').AsFloat := dDescuento;
	
	if IVA1 <> 0 then
	ADOQueryToMaster.FieldByName('TotalIVA1').AsFloat := IVA1;
	if IVA2 <> 0 then
	ADOQueryToMaster.FieldByName('TotalIVA2').AsFloat := IVA2;
	if IVA3 <> 0 then
	ADOQueryToMaster.FieldByName('TotalIVA3').AsFloat := IVA3;
	
	if RE1 <> 0 then
	ADOQueryToMaster.FieldByName('TotalRE1').AsFloat := RE1;
	if RE2 <> 0 then
	ADOQueryToMaster.FieldByName('TotalRE2').AsFloat := RE2;
	if RE3 <> 0 then
	ADOQueryToMaster.FieldByName('TotalRE3').AsFloat := RE3;
	
	if IRPF <> 0 then
	ADOQueryToMaster.FieldByName('TotalIRPF').AsFloat := IRPF;
	
	ADOQueryToMaster.FieldByName('TOTAL').AsFloat := TOTAL;

	

	Result := TOTAL;

end;



procedure GenerarArchivos(sValues: string);
var
  sMASTERFROM, sDETAILFROM, sMASTERTO, sDETAILTO, sPLAZOSFROM, sPLAZOSTO, sKeyFrom, sKeyTo, sKeyPartner, sArchivo, sTablaOrigen, sTablaDestino, sYear, sQuery, sNumero, sID, sIDP, sSerieInicial, sSerie: string;
  Year, Month, Day: Word;  
  dPlazosPagados, dRecibosPagados, dTotal, dParcial, dCentimo: double;
  nSigno, nPosicionPlazos, nPosicion, k, i, nRecibos, nDias1, nDiasN: integer;
  bProcesarStock, bPagado, bProcedencia: boolean;
  d: TDateTime;
  pQTPV : TFDQuery;
begin
	
	
	ADOQueryFromMaster.DisableControls;
	
	if sValues = '1' then
		bProcedencia := true;
		
	ADOQueryFromDetail := TFDQuery.Create(nil);
    ADOQueryFromPlazos := TFDQuery.Create(nil);
    ADOQueryToMaster := TFDQuery.Create(nil);
    ADOQueryToDetail := TFDQuery.Create(nil);
    ADOQueryToPlazos := TFDQuery.Create(nil);
	pQueryStock := TFDQuery.Create(nil);

    ADOQueryFromDetail.Connection := Query.Connection;
    ADOQueryFromPlazos.Connection := Query.Connection;
    ADOQueryToMaster.Connection := Query.Connection;
    ADOQueryToDetail.Connection := Query.Connection;
	ADOQueryToPlazos.Connection := Query.Connection;
	pQueryStock.Connection := Query.Connection;
		
	
	sMASTERFROM := QueryOrigen.FieldByName('Nombre').AsString;
	sDETAILFROM := QueryOrigen.FieldByName('Nombre').AsString + '_DATOS';
    sPLAZOSFROM := QueryOrigen.FieldByName('Nombre').AsString + '_PLAZOS';

    sMASTERTO := QueryDestino.FieldByName('Nombre').AsString;
    sDETAILTO := QueryDestino.FieldByName('Nombre').AsString + '_DATOS';
    sPLAZOSTO := QueryDestino.FieldByName('Nombre').AsString + '_PLAZOS';

    sKeyFrom := 'ID_' + QueryOrigen.FieldByName('Nombre').AsString;
    sKeyTo := 'ID_' + QueryDestino.FieldByName('Nombre').AsString;
    sKeyPartner := 'ID_PROVEEDORES';

    if QueryDestino.FieldByName('Tipo').AsString = 'DV' then
       sKeyPartner := 'ID_CLIENTES';

    sArchivo := QueryOrigen.FieldByName('DescripcionLoc').AsString + ': ';

	sTablaOrigen := QueryOrigen.FieldByName('ID_DOCUMENTOS_TIPOS').AsString;
    sTablaDestino := QueryDestino.FieldByName('ID_DOCUMENTOS_TIPOS').AsString;

    DecodeDate(Now(), Year, Month, Day);

    sYear := Copy(IntToStr(Year), 3, 4);

    if not ADOQueryFromMaster.Active then
        exit;

		

    ADOQueryToMaster.SQL.Text := 'SELECT * FROM ' + sMASTERTO + ' WHERE ' + sKeyTo + '=NULL';
    ADOQueryToMaster.Active := true;
    ADOQueryToDetail.SQL.Text := 'SELECT * FROM ' + sDETAILTO + ' WHERE ' + sKeyTo + '=NULL ORDER BY Posicion';
    ADOQueryToDetail.Active := true;
    ADOQueryToPlazos.SQL.Text := 'SELECT * FROM ' + sPLAZOSTO + ' WHERE ' + sKeyTo + '=NULL ORDER BY Posicion';
    ADOQueryToPlazos.Active := true;



    // Determinar si debo procesar el stock
	bProcesarStock := false;
    nSigno := 0;

	// Si el documento origen no tiene stock
    if not QueryOrigen.FieldByName('Stock').AsBoolean and QueryDestino.FieldByName('Stock').AsBoolean then
    begin
        bProcesarStock := true;
        nSigno := QueryDestino.FieldByName('StockSigno').AsInteger;
    end;


	if sMASTERFROM = 'TPV' then
	begin
		pQTPV := TFDQuery.Create(nil);
		pQTPV.Connection := Query.Connection;

		pQTPV.SQL.Text := 'SELECT * FROM CLIENTES WHERE ID_CLIENTES = ''0000'''; // TPV
		pQTPV.Active := true;

		if pQTPV.Eof then
		begin
			pQTPV.Insert();
			pQTPV.FieldByName('ID_CLIENTES').AsString := '0000';
			pQTPV.FieldByName('Nombre').AsString := 'TPV';
			pQTPV.Post();
		end;

		pQTPV.Free;
		
		ADOQueryFromMaster.First;

		while not ADOQueryFromMaster.Eof do
		begin
				ADOQueryFromMaster.Edit();
				ADOQueryFromMaster.FieldByName('ID_CLIENTES').AsString := '0000';
				ADOQueryFromMaster.FieldByName('Nombre').AsString := 'TPV';
				ADOQueryFromMaster.Post();
				ADOQueryFromMaster.Next();
		end;
		
		
    end;
	
	

    ADOQueryFromMaster.Filter := 'Traspasado=true';
    ADOQueryFromMaster.Filtered := true;
	
	

    ADOQueryFromMaster.First;

    while not ADOQueryFromMaster.Eof do
    begin
		if sMASTERFROM = 'TPV' then
		begin
			ADOQueryFromMaster.Edit;
			ADOQueryFromMaster.FieldByName('ID_CLIENTES').AsString := '0000';
			ADOQueryFromMaster.FieldByName('Nombre').AsString := 'TPV';
			ADOQueryFromMaster.Post;
		end;
		
		if ADOQueryFromMaster.FieldByName(sKeyPartner).AsString = '' then break;

        sID := ADOQueryFromMaster.FieldByName(sKeyPartner).AsString;

		
		// SERIE
		sIDP := ADOQueryFromMaster.FieldByName(sKeyFrom).AsString;
		sSerie := GetSerie(sIDP);
					
		
        sSerieInicial := sSerie;

        // Siguiente indice
        sNumero := zGetNextDataBaseId(sMASTERTO, sKeyTo, sYear + QueryDestino.FieldByName('Serie').AsString + sSerie + '%');
        if sNumero = '' then
        begin
            sNumero := sYear + QueryDestino.FieldByName('Serie').AsString + sSerie + '00001';
        end;
		
		
		
		ADOQueryToDetail.Active := false;
		ADOQueryToDetail.Active := true;
		
		ADOQueryToPlazos.Active := false;
		ADOQueryToPlazos.Active := true;

        // Cabecera de archivo
        ADOQueryToMaster.Insert();
		
		
		
		FillInDataSet(ADOQueryFromMaster, ADOQueryToMaster, '');
		
        ADOQueryToMaster.FieldByName(sKeyTo).AsString := sNumero;
        ADOQueryToMaster.FieldByName('Fecha').AsDateTime := Date();
		ADOQueryToMaster.FieldByName(sKeyPartner).AsString :=
            ADOQueryFromMaster.FieldByName(sKeyPartner).AsString;
       
	    if FindField(ADOQueryToMaster, 'Traspasado') then
			ADOQueryToMaster.FieldByName('Traspasado').AsBoolean := false;

        ADOQueryToMaster.Post();
		
		

        nPosicion := 1;
        nPosicionPlazos := 1;

		dPlazosPagados := 0;

		bPagado := ADOQueryToMaster.FieldByName('Pagado').AsBoolean;


    

        // Buscar en todas los archivos del mismo cliente
        //for ( int c := 0; c < cxGridDocsDBTableView1.ViewData.RowCount; c++ ) // Recorrer los documentos seleccionados
        while ADOQueryFromMaster.Locate(sKeyPartner, sID, loCaseInsensitive) do
        begin

			
			
			sIDP := ADOQueryFromMaster.FieldByName(sKeyFrom).AsString;
			sSerie := GetSerie(sIDP);
						
			
			if ( sSerieInicial <> sSerie ) then // Distinta serie
				break;

			//ShowMessage(sSerie);
            // Mismo cliente o proveedor Y CONDICIONES
            if
                (ADOQueryToMaster.FieldByName(sKeyPartner).AsString = ADOQueryFromMaster.FieldByName(sKeyPartner).AsString) and
                (ADOQueryToMaster.FieldByName('SinIVA').AsBoolean = ADOQueryFromMaster.FieldByName('SinIVA').AsBoolean) and
                (ADOQueryToMaster.FieldByName('ConRE').AsBoolean = ADOQueryFromMaster.FieldByName('ConRE').AsBoolean) and
                (ADOQueryToMaster.FieldByName('ConIRPF').AsBoolean = ADOQueryFromMaster.FieldByName('ConIRPF').AsBoolean) and
                (ADOQueryToMaster.FieldByName('IRPF').AsFloat = ADOQueryFromMaster.FieldByName('IRPF').AsFloat) and
                (ADOQueryToMaster.FieldByName('ID_FORMAS_PAGO').AsString = ADOQueryFromMaster.FieldByName('ID_FORMAS_PAGO').AsString) and
                (ADOQueryToMaster.FieldByName('Descuento').AsFloat = ADOQueryFromMaster.FieldByName('Descuento').AsFloat) then
            begin

                // condiciones de ventas
				if (FindField(ADOQueryToMaster, 'ID_COMERCIALES')) and (FindField(ADOQueryFromMaster, 'ID_COMERCIALES')) then
                begin
                  if (ADOQueryToMaster.FieldByName('ID_COMERCIALES').AsString <> ADOQueryFromMaster.FieldByName('ID_COMERCIALES').AsString) or
                   (ADOQueryToMaster.FieldByName('Comision').AsFloat <> ADOQueryFromMaster.FieldByName('Comision').AsFloat) then
				   begin
                      break;
					end;
                end;

				
				

                // Acumular observaciones
                if  ADOQueryFromMaster.FieldByName('Observaciones').AsString <> '' then
                begin
                    ADOQueryToMaster.Edit();
                    ADOQueryToMaster.FieldByName('Observaciones').AsString :=
						        ADOQueryToMaster.FieldByName('Observaciones').AsString + ADOQueryFromMaster.FieldByName('Observaciones').AsString + #13+#10;

					//ADOQueryToMaster.FieldByName('Observaciones').AsString :=

                    ADOQueryToMaster.Post();
				end;

				if bPagado then // Comprobar mientras todos los documentos estan pagados
					bPagado := ADOQueryFromMaster.FieldByName('Pagado').AsBoolean;

							
 // >>>>>               // marcar como traspasado
                sQuery := Format('UPDATE %s SET Traspasado=1 WHERE %s=''%s''',
                  [
                    sMASTERFROM,
                    sKeyFrom,
                    ADOQueryFromMaster.FieldByName(sKeyFrom).AsString
                    ]);
                //ADOQueryFromMaster.Edit();
                //ADOQueryFromMaster.FieldByName('Traspasado').AsBoolean := true;
                //ADOQueryFromMaster.Post();
				
				

                Query.SQL.Text := sQuery;
                Query.ExecSQL;

				

                // Desmarcar
                //cxGridDocsDBTableView1.ViewData.Rows[c].Values[0] := (bool)false;

                sQuery := Format('INSERT INTO TRASPASOS (ID_TABLA_ORIGEN, ID_ORIGEN, ID_TABLA_DESTINO, ID_DESTINO ) VALUES(''%s'', ''%s'', ''%s'', ''%s'')',
                  [
                    sTablaOrigen,
                    ADOQueryFromMaster.FieldByName(sKeyFrom).AsString,
                    sTablaDestino,
                    sNumero
                    ]);


                Query.SQL.Text := sQuery;
                Query.ExecSQL;
                // FIN marcar como traspasado




                // Detalles de factura
                ADOQueryFromDetail.SQL.Text :=
                    'SELECT * FROM ' + sDETAILFROM + ' WHERE ' + sKeyFrom + '=''' + ADOQueryFromMaster.FieldByName(sKeyFrom).AsString + ''' ORDER BY Posicion';
                ADOQueryFromDetail.Active := true;

				
				
                if bProcedencia then
                begin
                  // Introducir cabeceras en detalles para saber de donde procede
                  sQuery := Format('INSERT INTO %s (Posicion, %s, Descripcion ) VALUES(%s, ''%s'', ''%s'')',
                  [
                    sDETAILTO,
                    sKeyTo,
                    IntToStr(nPosicion),
                    sNumero,

                    sArchivo +
                    ADOQueryFromMaster.FieldByName(sKeyFrom).AsString + ' - ' +
                    ADOQueryFromMaster.FieldByName('Fecha').AsString

                    ]);

   

                  nPosicion := nPosicion + 1;

                  Query.SQL.Text := sQuery;
                  Query.ExecSQL;

                end;

                while not ADOQueryFromDetail.Eof do
                begin


                    ADOQueryToDetail.Insert();
					
					/// CUSTOM FIELDS
					FillInDataSet(ADOQueryFromDetail, ADOQueryToDetail, '');
					
                    ADOQueryToDetail.FieldByName(sKeyTo).AsString := sNumero;
                    ADOQueryToDetail.FieldByName('Posicion').AsInteger := nPosicion;                    

                    nPosicion := nPosicion + 1;


                    ADOQueryToDetail.Post();

                    if bProcesarStock then
                    begin

						pQueryStock.SQL.Text := 'SELECT * FROM PRODUCTOS WHERE ID_PRODUCTOS = ''' +
							ADOQueryToDetail.FieldByName('ID_PRODUCTOS').AsString + '''';

						pQueryStock.Active := true;
						if (not pQueryStock.Eof) and (not pQueryStock.FieldByName('SinStock').AsBoolean) then
						begin

							pQueryStock.Edit();

							pQueryStock.FieldByName('Stock').AsFloat :=
								pQueryStock.FieldByName('Stock').AsFloat +
								nSigno * ADOQueryToDetail.FieldByName('Cantidad').AsFloat;

							pQueryStock.Post();
						end;
					end;

					ADOQueryFromDetail.Next();
					
                end;
				
				
				

				// PLAZOS PAGADOS

				
				
                ADOQueryFromPlazos.SQL.Text :=
                    'SELECT * FROM ' + sPLAZOSFROM + ' WHERE ' + sKeyFrom + '=''' + ADOQueryFromMaster.FieldByName(sKeyFrom).AsString + ''' ORDER BY Posicion';
                ADOQueryFromPlazos.Active := true;

                while not ADOQueryFromPlazos.Eof do
                begin
                    if ADOQueryFromPlazos.FieldByName('Pagado').AsBoolean then // Si estÃ¡ pagado lo traspasamos
                    begin
                        ADOQueryToPlazos.Insert();
												
						FillInDataSet(ADOQueryFromPlazos, ADOQueryToPlazos, '');
						
                        ADOQueryToPlazos.FieldByName(sKeyTo).AsString := sNumero;
                        ADOQueryToPlazos.FieldByName('Posicion').AsInteger := nPosicionPlazos;
                        

                        ADOQueryToPlazos.Post();

                        nPosicionPlazos := nPosicionPlazos + 1;

                        dPlazosPagados := dPlazosPagados + ADOQueryFromPlazos.FieldByName('Importe').AsFloat;
                    end;

                    ADOQueryFromPlazos.Next();
                end;
                // FIN PLAZOS PAGADOS

				
				
				ADOQueryToMaster.Edit();
				
				ADOQueryToMaster.FieldByName('Pagado').AsBoolean := bPagado;

                
				
				CalcularPrecios('');
								

                ADOQueryToMaster.Post();

            end
			else
				break; /// NO CUMPLE CONDICIONES

		
	    
		
			ADOQueryFromMaster.Delete;
			
			
	   
			if (ADOQueryFromMaster.Eof) and (ADOQueryFromMaster.Bof) then 
				break;
	   //ADOQueryFromMaster.First;
	   //Application.ProcessMessages();
       //ADOQueryFromMaster.FieldByName('Traspasado').AsBoolean := false;  // Quitar de la lista
       //ADOQueryFromMaster.Post;

			
	   
        end;

        // PLAZOS A GENERAR

        if ( ADOQueryToMaster.FieldByName('ID_FORMAS_PAGO').AsString <> '' ) then
        begin
			//ShowMessage('CalcularPlazos');
			CalcularPlazos(sKeyTo, sNumero);
			
        end;

		// FIN PLAZOS A GENERAR



    //Query1.FieldByName('Traspasar').AsBoolean := false; // ya traspasado

	end;

	
	
	
	ADOQueryFromMaster.Filtered := false;
	ADOQueryFromMaster.Filter := '';
	//ADOQueryFromMaster.Active := false;

	
	ADOQueryFromDetail.Free;
	ADOQueryFromPlazos.Free;
	ADOQueryToMaster.Free;
	ADOQueryToDetail.Free;
	ADOQueryToPlazos.Free;
	pQueryStock.Free;
	
	ADOQueryFromMaster.EnableControls;

	ShowMessage(zLocalize('El proceso se ha completado con éxito.'));
end;

begin

end.