var
	bUpdating: boolean;
	vLastResult: Variant;
	IVA1, IVA2, IVA3, RE1, RE2, RE3, IRPF, TOTAL: double;


function FindField(ds: TDataSet; sFieldName: string):boolean;
var
	i: integer;
begin
	result:= false;
	
	for i:=0 to ds.FieldCount-1 do
	  if ds.Fields[i].FieldName = sFieldName then
		result:= true;
		
end;

procedure FillInDataSet(pO, pD: TDataSet; sFieldIgnore: string);
var
	i: integer;
begin
	for i:=0 to pD.FieldCount-1 do
		if FindField(pO, pD.Fields[i].FieldName) and not(Pos(pD.Fields[i].FieldName, sFieldIgnore)>0) and not(pD.Fields[i] is TAutoIncField) then
		begin
			//showmessage(pD.Fields[i].FieldName);
			pD.Fields[i].Value := pO.FieldByName(pD.Fields[i].FieldName).Value;
			
		end;
end;

function ParseQuery(sQuery: String):String;
begin
	Result:=zReplace(sQuery, '''', '''''');
end;


function CalcularPrecios(sField: String):double;
var
   dBases, dIVAs, dREs:array[1..3] of double;
   nCantidad, dPrecio, dDescuento, dIva, dIRPF, dCoeficiente: double;
   IdIva, f: integer;
   bExiste: boolean;
   bm: string;
begin

  IdIva := 0;
  bExiste := false;
  for f := 1 to 3 do
  begin
       dBases[f] := 0;
       dIVAs[f] := 0;
       dREs[f] := 0;
  end;
  

  
	ClientDataSetMaster.Edit;
	ClientDataSetMaster.FieldByName('BaseImponible1').AsString := '';
	ClientDataSetMaster.FieldByName('BaseImponible2').AsString := '';
	ClientDataSetMaster.FieldByName('BaseImponible3').AsString := '';
	ClientDataSetMaster.FieldByName('IVA1').AsString := '';
	ClientDataSetMaster.FieldByName('IVA2').AsString := '';
	ClientDataSetMaster.FieldByName('IVA3').AsString := '';
	ClientDataSetMaster.FieldByName('RE1').AsString := '';
	ClientDataSetMaster.FieldByName('RE2').AsString := '';
	ClientDataSetMaster.FieldByName('RE3').AsString := '';
	
	ClientDataSetMaster.FieldByName('TotalDescuento').AsString := '';
	
	ClientDataSetMaster.FieldByName('TotalIVA1').AsString := '';
	ClientDataSetMaster.FieldByName('TotalIVA2').AsString := '';
	ClientDataSetMaster.FieldByName('TotalIVA3').AsString := '';
	
	ClientDataSetMaster.FieldByName('TotalRE1').AsString := '';
	ClientDataSetMaster.FieldByName('TotalRE2').AsString := '';
	ClientDataSetMaster.FieldByName('TotalRE3').AsString := '';
	
	ClientDataSetMaster.FieldByName('TotalIRPF').AsString := '';
	
	ClientDataSetMaster.FieldByName('TOTAL').AsString := '';

	if (ClientDataSetDetalles.Eof) and (ClientDataSetDetalles.Bof) then exit;
	
	bm := ClientDataSetDetalles.Fields[0].AsString;
	ClientDataSetDetalles.DisableControls();
	
	ClientDataSetDetalles.First;

	while not ClientDataSetDetalles.Eof do
	begin

		
		
      nCantidad := ClientDataSetDetalles.FieldByName('Cantidad').AsFloat;
      dPrecio := zRound(ClientDataSetDetalles.FieldByName('Precio').AsFloat, QueryConfiguracion.FieldByName('DecimalesMoneda').AsInteger);
      dDescuento := ClientDataSetDetalles.FieldByName('Descuento').AsFloat;
      dIva := ClientDataSetDetalles.FieldByName('IVA').AsFloat;
	  
	  {dCoeficiente := 1;	  
	  if FindField(ClientDataSetDetalles, 'Coeficiente') then
		dCoeficiente := ClientDataSetDetalles.FieldByName('Coeficiente').AsFloat;}

      if (nCantidad = 0)  then
        begin
            ClientDataSetDetalles.Next;
            continue;
        end;
		
	 
	
	 ClientDataSetDetalles.Edit;
	 if sField = 'Importe' then
	 begin		
		ClientDataSetDetalles.FieldByName('Precio').AsFloat := zRound(ClientDataSetDetalles.FieldByName('Importe').AsFloat / nCantidad / (dIVA/100 + 1) / (1 - dDescuento/100), QueryConfiguracion.FieldByName('DecimalesMoneda').AsInteger);
	 end
	 else
		ClientDataSetDetalles.FieldByName('Importe').AsFloat := zRound(nCantidad * ( dPrecio * (100 - dDescuento ) / 100 )) * ((dIVA/100 + 1));	

      // Para cada tipo de IVA
      if ( IdIva = 0 ) then
      begin
           IdIva := IdIva + 1;

            dIVAs[IdIva] := dIva;
            dBases[IdIva] := dBases[IdIva] + zRound(nCantidad * ( dPrecio * (100 - dDescuento ) / 100 ));


      end
      else
      begin
            // Recorrer todos los IVAS para ver si ya esta en la lista
            bExiste := false;
            for f := 1 to IdIva do
            begin
                if ( dIVAs[f] = dIva ) then
                begin
                    dBases[f] := dBases[f] + zRound( nCantidad * ( dPrecio * (100 - dDescuento ) / 100 ));
                    bExiste := true;
                end;
            end;
            if ( not bExiste ) then  // Nuevo tipo de iva
            begin
                 IdIva := IdIva + 1;
				 
				 if idIVA > 3 then		 
					idIVA := 3;
				 

                dIVAs[IdIva] := dIva;
                dBases[IdIva] := dBases[IdIva] + zRound( nCantidad * ( dPrecio * (100 - dDescuento ) / 100 ));


            end;
      end;


	ClientDataSetDetalles.Next;

	end;
	
	
	if bm <> '' then	
		ClientDataSetDetalles.Locate(ClientDataSetDetalles.Fields[0].FieldName, bm, loCaseInsensitive);	
	
	ClientDataSetDetalles.EnableControls();
	
	



	// DESCUENTO GENERAL
	for f := 1 to IdIva do
    begin

        dDescuento := (ClientDataSetMaster.FieldByName('Descuento').AsFloat / 100);


		dDescuento := zRound(dDescuento * dBases[f]);

		dBases[f] := dBases[f] - dDescuento;

		dBases[f] := zRound(dBases[f]);


    end;


	// BASES E IVA, RE
    ClientDataSetMaster.Edit;
    for f := 1 to IdIva do
    begin
         ClientDataSetMaster.FieldByName('BaseImponible' + IntToStr(f)).AsFloat := dBases[f];
         ClientDataSetMaster.FieldByName('IVA' + IntToStr(f)).AsFloat := dIVAs[f];
		 

		 if ClientDataSetMaster.FieldByName('ConRE').AsBoolean then
		 begin
			if dIVAs[f] = QueryConfiguracion.FieldByName('IVAGeneral').AsFloat then
                ClientDataSetMaster.FieldByName('RE' + IntToStr(f)).AsFloat := QueryConfiguracion.FieldByName('REGeneral').AsFloat
			else
			if dIVAs[f] = QueryConfiguracion.FieldByName('IVAReducido').AsFloat then
                ClientDataSetMaster.FieldByName('RE' + IntToStr(f)).AsFloat := QueryConfiguracion.FieldByName('REReducido').AsFloat
			else
			if dIVAs[f] = QueryConfiguracion.FieldByName('IVASuperReducido').AsFloat then
                ClientDataSetMaster.FieldByName('RE' + IntToStr(f)).AsFloat := QueryConfiguracion.FieldByName('RESuperReducido').AsFloat;
		 end;

    end;
    //ClientDataSetMaster.Post;

		//
		
    IVA1 := zRound(ClientDataSetMaster.FieldByName('BaseImponible1').AsFloat * ClientDataSetMaster.FieldByName('IVA1').AsFloat/100);
    IVA2 := zRound(ClientDataSetMaster.FieldByName('BaseImponible2').AsFloat * ClientDataSetMaster.FieldByName('IVA2').AsFloat/100);
    IVA3 := zRound(ClientDataSetMaster.FieldByName('BaseImponible3').AsFloat * ClientDataSetMaster.FieldByName('IVA3').AsFloat/100);

    RE1 := zRound(ClientDataSetMaster.FieldByName('BaseImponible1').AsFloat * ClientDataSetMaster.FieldByName('RE1').AsFloat/100);
    RE2 := zRound(ClientDataSetMaster.FieldByName('BaseImponible2').AsFloat * ClientDataSetMaster.FieldByName('RE2').AsFloat/100);
    RE3 := zRound(ClientDataSetMaster.FieldByName('BaseImponible3').AsFloat * ClientDataSetMaster.FieldByName('RE3').AsFloat/100);

	IRPF := 0;
    if ClientDataSetMaster.FieldByName('ConIRPF').AsBoolean then
	begin
		IRPF := ClientDataSetMaster.FieldByName('BaseImponible1').AsFloat + ClientDataSetMaster.FieldByName('BaseImponible2').AsFloat + ClientDataSetMaster.FieldByName('BaseImponible3').AsFloat;
		
		if QueryConfiguracion.FieldByName('CalcularIRPFGlobal').AsBoolean then
				IRPF := IRPF + IVA1 + IVA2 + IVA3;
				
		IRPF := zRound(ClientDataSetMaster.FieldByName('IRPF').AsFloat / 100 * (IRPF));
		 
	end
	else
		ClientDataSetMaster.FieldByName('IRPF').AsFloat := 0;


	TOTAL :=
		ClientDataSetMaster.FieldByName('BaseImponible1').AsFloat+
		ClientDataSetMaster.FieldByName('BaseImponible2').AsFloat+
		ClientDataSetMaster.FieldByName('BaseImponible3').AsFloat+
		IVA1+IVA2+IVA3+
		RE1+RE2+RE3
		-
		IRPF;
		
		
	if dDescuento <> 0 then
	ClientDataSetMaster.FieldByName('TotalDescuento').AsFloat := dDescuento;
	
	if IVA1 <> 0 then
	ClientDataSetMaster.FieldByName('TotalIVA1').AsFloat := IVA1;
	if IVA2 <> 0 then
	ClientDataSetMaster.FieldByName('TotalIVA2').AsFloat := IVA2;
	if IVA3 <> 0 then
	ClientDataSetMaster.FieldByName('TotalIVA3').AsFloat := IVA3;
	
	if RE1 <> 0 then
	ClientDataSetMaster.FieldByName('TotalRE1').AsFloat := RE1;
	if RE2 <> 0 then
	ClientDataSetMaster.FieldByName('TotalRE2').AsFloat := RE2;
	if RE3 <> 0 then
	ClientDataSetMaster.FieldByName('TotalRE3').AsFloat := RE3;
	
	if IRPF <> 0 then
	ClientDataSetMaster.FieldByName('TotalIRPF').AsFloat := IRPF;
	
	ClientDataSetMaster.FieldByName('TOTAL').AsFloat := TOTAL;

	

	Result := TOTAL;

end;

procedure CalcularPlazos();
var
  sKey: String;
  nDiaPago, nDias1, nDiasN, nRecibos, nNuevaPosicion, i: integer;
  dTotal, dRecibosPagados, dParcial, dCentimo: double;
  d, LastMonthDay: TDateTime;
  Year, Month, Day, LastDay, nMaxDay: Word;
begin
	if FindField(ClientDataSetMaster, 'ID_INGRESOS_PROGRAMADOS') then exit;
	
    if (ClientDataSetMaster.FieldByName('TOTAL').AsFloat = 0) or
       (ClientDataSetMaster.FieldByName('ID_FORMAS_PAGO').AsString = '')
    then
		  exit;

	Query.SQL.Text := 'SELECT * FROM FORMAS_PAGO WHERE ID_FORMAS_PAGO = ''' + ClientDataSetMaster.FieldByName('ID_FORMAS_PAGO').AsString + '''';
	  Query.Active := true;
	  
	nRecibos := Query.FieldByName('NumeroRecibos').AsInteger;
	nDias1 := Query.FieldByName('PrimerRecibo').AsInteger;
	nDiasN := Query.FieldByName('RestoRecibos').AsInteger;

	
	
    if FindField(ClientDataSetMaster, 'ID_CLIENTES') then
	begin
		sKey := 'ID_CLIENTES';
		Query.SQL.Text := 'SELECT * FROM CLIENTES WHERE ' + sKey + ' = ''' + ClientDataSetMaster.FieldByName(sKey).AsString + '''';
	end
	else
	begin
		sKey := 'ID_PROVEEDORES';
		Query.SQL.Text := 'SELECT * FROM PROVEEDORES WHERE ' + sKey + ' = ''' + ClientDataSetMaster.FieldByName(sKey).AsString + '''';
	end;
	
	Query.Active := true;
	  //DataSourcePartner.DataSet.Locate(sKey, ClientDataSetMaster.FieldByName(sKey).Text, []);

	  nDiaPago := Query.FieldByName('DiaPago').AsInteger; 

	
    //ClientDataSetPlazos := TClientDataSet(DataSourcePlazos.DataSet);
    //ClientDataSetPlazos.DisableControls();

    dTotal := ClientDataSetMaster.FieldByName('TOTAL').AsFloat;
    dRecibosPagados := 0;

    nNuevaPosicion := 1;

    ClientDataSetPlazos.First();
	
	//ShowMessage(ClientDataSetMaster.FieldByName('TOTAL').AsFloat);
	
    while not ClientDataSetPlazos.Eof do
    begin
        if ClientDataSetPlazos.FieldByName('Pagado').AsBoolean then
        begin
            dRecibosPagados := dRecibosPagados + ClientDataSetPlazos.FieldByName('Importe').AsFloat;
        end;

        ClientDataSetPlazos.Next();
    end;
		
    // Borrar ahora para que no descuadre
    ClientDataSetPlazos.First();
    while not ClientDataSetPlazos.Eof do
        if ClientDataSetPlazos.FieldByName('Pagado').AsBoolean then
            ClientDataSetPlazos.Next()
        else
            ClientDataSetPlazos.Delete();



    dParcial := StrToFloat(FormatFloat('#0.##', (dTotal - dRecibosPagados) / nRecibos));

    dCentimo := (dTotal - dRecibosPagados) - dParcial * nRecibos;

	if dParcial <> 0 then
    for i := 1 to nRecibos do
    begin
        ClientDataSetPlazos.Insert();

		ClientDataSetPlazos.FieldByName('Posicion').AsInteger := nNuevaPosicion;

    nNuevaPosicion:= nNuevaPosicion + 1;



    if i = 1 then
      d := ClientDataSetMaster.FieldByName('Fecha').AsDateTime + nDias1
    else
      d := ClientDataSetMaster.FieldByName('Fecha').AsDateTime + nDias1 + nDiasN * (i - 1);


		if nDiaPago <> 0 then
		begin
			
			DecodeDate(d, Year, Month, Day);
			LastDay := DaysInMonth(Year, Month);

			//DecodeDate(LastMonthDay, Year, Month, LastDay);
			DecodeDate(d, Year, Month, Day);

			// Determinar que no se facture un 30 de febrero ...
      if nDiaPago > LastDay then
  			nMaxDay := LastDay
      else
         nMaxDay := nDiaPago;

			while nMaxDay <> Day do
			begin

				d := d + 1;
				DecodeDate(d, Year, Month, Day);
			end;

		end;

		ClientDataSetPlazos.FieldByName('Fecha').AsDateTime := d ;

        ClientDataSetPlazos.FieldByName('Concepto').AsString := Format(QueryConfiguracion.FieldByName('Plazo').AsString, [IntToStr(i), ClientDataSetMaster.Fields[0].AsString]);;
            //'Vencimiento N ' + String(i) + ' del documento ' + DBEditNumero.Text;

        ClientDataSetPlazos.FieldByName('Importe').AsString := FormatFloat('#0.##', dParcial + dCentimo);

        dCentimo := 0;

        ClientDataSetPlazos.Post();
    end;

    //ClientDataSetPlazos.EnableControls();


end;



procedure PlazoPagado();
var
   dRecibosPagados: double;
   bm: string;
begin
	if FindField(ClientDataSetMaster, 'ID_INGRESOS_PROGRAMADOS') then exit;
	
	if (ClientDataSetPlazos.Eof) and (ClientDataSetPlazos.Bof) then exit;	
	
	dRecibosPagados := 0;
	
	bm := ClientDataSetPlazos.Fields[0].AsString;
	ClientDataSetPlazos.DisableControls();
	
    ClientDataSetPlazos.First();
	
	
	
    while not ClientDataSetPlazos.Eof do
    begin
	
        if ClientDataSetPlazos.FieldByName('Pagado').AsBoolean then
        begin
            dRecibosPagados := dRecibosPagados + ClientDataSetPlazos.FieldByName('Importe').AsFloat;
        end;

        ClientDataSetPlazos.Next();
    end;
	
	
	ClientDataSetPlazos.Locate(ClientDataSetPlazos.Fields[0].FieldName, bm, loCaseInsensitive);		
	ClientDataSetPlazos.EnableControls();
		
	ClientDataSetMaster.FieldByName('TotalPendiente').AsFloat := zRound(ClientDataSetMaster.FieldByName('TOTAL').AsFloat - dRecibosPagados);
	
	ClientDataSetMaster.FieldByName('Pagado').AsBoolean := (ClientDataSetMaster.FieldByName('TotalPendiente').AsFloat = 0);
	
	// WorkAround para no disparar documentoPagado
	ClientDataSetMaster.FieldByName('TotalPendiente').AsFloat := zRound(ClientDataSetMaster.FieldByName('TOTAL').AsFloat - dRecibosPagados);
	
end;

procedure DocumentoPagado();
var
   dRecibosPagados, dTotal: double;
   bm: string;
begin
	
	Query.Active := false;
	
	if FindField(ClientDataSetMaster, 'ID_INGRESOS_PROGRAMADOS') then exit;

	

	if (ClientDataSetPlazos.Eof) and (ClientDataSetPlazos.Bof) then exit;
	
	dRecibosPagados := 0;
	
	bm := ClientDataSetPlazos.Fields[0].AsString;
	ClientDataSetPlazos.DisableControls();

	
    ClientDataSetPlazos.First();
	
	
    while not ClientDataSetPlazos.Eof do
    begin
		ClientDataSetPlazos.Edit();
        ClientDataSetPlazos.FieldByName('Pagado').AsBoolean := ClientDataSetMaster.FieldByName('Pagado').AsBoolean;
        ClientDataSetPlazos.Post();
				
		if ClientDataSetPlazos.FieldByName('Pagado').AsBoolean then
			dRecibosPagados := dRecibosPagados + ClientDataSetPlazos.FieldByName('Importe').AsFloat;

        ClientDataSetPlazos.Next();
    end;
	
	
	ClientDataSetPlazos.Locate(ClientDataSetPlazos.Fields[0].FieldName, bm, loCaseInsensitive);		
	ClientDataSetPlazos.EnableControls();
		

	ClientDataSetMaster.FieldByName('TotalPendiente').AsFloat := zRound(ClientDataSetMaster.FieldByName('TOTAL').AsFloat - dRecibosPagados);
	
	ClientDataSetMaster.FieldByName('Pagado').AsBoolean := (ClientDataSetMaster.FieldByName('TotalPendiente').AsFloat = 0);
	
end;

procedure SinIVA();
var
	bm: string;
begin
	if (ClientDataSetDetalles.Eof) and (ClientDataSetDetalles.Bof) then exit;
	
	bm := ClientDataSetDetalles.Fields[0].AsString;
	ClientDataSetDetalles.DisableControls();
	
// Quitar IVA de los productos
	if ClientDataSetMaster.FieldByName('SinIVA').AsBoolean then
	begin
    ClientDataSetDetalles.First();
		while not ClientDataSetDetalles.Eof do
		begin
			ClientDataSetDetalles.Edit();
			ClientDataSetDetalles.FieldByName('IVA').AsFloat := 0;
			//DataSourceDetalles.Post();

      ClientDataSetDetalles.Next();
		end;
	end
	else // Añadir el IVA de cada producto
	begin
    ClientDataSetDetalles.First();
		while not ClientDataSetDetalles.Eof do
		begin
			Query.SQL.Text := 'SELECT IVA FROM PRODUCTOS WHERE ID_PRODUCTOS = ''' + ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString + '''';
			Query.Active := true;

			if not Query.Eof then
			begin
				ClientDataSetDetalles.Edit();
				ClientDataSetDetalles.FieldByName('IVA').AsFloat := Query.FieldByName('IVA').AsFloat;
				//DataSourceDetalles.Post();
			end;

      ClientDataSetDetalles.Next();

		end;
	end;
	
	ClientDataSetDetalles.Locate(ClientDataSetDetalles.Fields[0].FieldName, bm, loCaseInsensitive);		
	ClientDataSetDetalles.EnableControls();
end;

procedure AplicarTarifa();
var
  dPrecio, nCantidad: double;
  sPrecio: string;
  bm: string;
begin
	if (ClientDataSetDetalles.Eof) and (ClientDataSetDetalles.Bof) then exit;
	
	bm := ClientDataSetDetalles.Fields[0].AsString;
	ClientDataSetDetalles.DisableControls();
	
    nCantidad := 0;

    sPrecio := 'Precio1';

    if ClientDataSetMaster.FieldByName('Tarifa').AsString <> '' then
        sPrecio := 'Precio' + ClientDataSetMaster.FieldByName('Tarifa').AsString;


    // Calcular el precio

    ClientDataSetDetalles.First();
    while not ClientDataSetDetalles.Eof do
    begin
        if ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString <> '' then
        begin
            Query.SQL.Text := 'SELECT * FROM PRODUCTOS WHERE ID_PRODUCTOS = ''' + ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString + '''';
            Query.Active := true;

            if not Query.Eof then
            begin
                ClientDataSetDetalles.Edit();
                
                ClientDataSetDetalles.FieldByName('Precio').AsFloat := Query.FieldByName(sPrecio).AsFloat;
                ClientDataSetDetalles.FieldByName('IVA').AsFloat := Query.FieldByName('IVA').AsFloat;
                ClientDataSetDetalles.FieldByName('Descuento').AsFloat := Query.FieldByName('Descuento').AsFloat;

                //ClientDataSetDetalles.Post();
            end;
        
        end;

        ClientDataSetDetalles.Next();

    end;

    
	if not ClientDataSetDetalles.Eof then
	ClientDataSetDetalles.Locate(ClientDataSetDetalles.Fields[0].FieldName, bm, loCaseInsensitive);		
	ClientDataSetDetalles.EnableControls();

end;

procedure AsignarComision();
begin
  
	Query.SQL.Text := 'SELECT * FROM COMERCIALES WHERE ID_COMERCIALES = ''' + ClientDataSetMaster.FieldByName('ID_COMERCIALES').AsString + '''';
    Query.Active := true;
			
    ClientDataSetMaster.Edit();

		ClientDataSetMaster.FieldByName('Comision').AsFloat :=
			Query.FieldByName('Comision').AsFloat;
  
end;

procedure ProductosChange(sKey: string);
var
  sPrecio: string;
  
begin
	
	//ShowMessage(sKey);

	if sKey = 'Descripcion' then
		Query.SQL.Text := 'SELECT * FROM PRODUCTOS WHERE Nombre = ''' + ParseQuery(ClientDataSetDetalles.FieldByName(sKey).AsString) + ''''
	else
		Query.SQL.Text := 'SELECT * FROM PRODUCTOS WHERE '+sKey+' = ''' + ParseQuery(ClientDataSetDetalles.FieldByName(sKey).AsString) + '''';	
		
    Query.Active := true;

    if not Query.Eof then
    begin
	  ClientDataSetDetalles.Edit;	
	  
	  /// CUSTOM FIELDS
	  FillInDataSet(Query, ClientDataSetDetalles, '');
	  
      ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString := Query.FieldByName('ID_PRODUCTOS').AsString;
      ClientDataSetDetalles.FieldByName('Descripcion').AsString := Query.FieldByName('Nombre').AsString;
      ClientDataSetDetalles.FieldByName('Cantidad').AsFloat := 1;
      ClientDataSetDetalles.FieldByName('Descuento').AsFloat := Query.FieldByName('Descuento').AsFloat;

      if FindField(ClientDataSetMaster, 'Tarifa') then
      begin
        sPrecio := 'Precio1';

        if ClientDataSetMaster.FieldByName('Tarifa').AsString <> '' then
            sPrecio := 'Precio' + ClientDataSetMaster.FieldByName('Tarifa').AsString;

      end
      else
        sPrecio := 'PrecioCompra';

      ClientDataSetDetalles.FieldByName('Precio').AsFloat := Query.FieldByName(sPrecio).AsFloat;
      ClientDataSetDetalles.FieldByName('IVA').AsFloat := Query.FieldByName('IVA').AsFloat;	

	  if ClientDataSetMaster.FieldByName('SinIVA').AsBoolean then
			ClientDataSetDetalles.FieldByName('IVA').AsFloat := 0;
			
      ClientDataSetDetalles.Post;
	  
	  CalcularPrecios('');
	  	  
	  
	  //ClientDataSetDetalles.AfterPost := nil;
	  
	  //ShowMessage('a');
	  Query.Tag := 1; // append
		
	  

	end;
	
	

end;

procedure ID_PartnerChange(sKey: string);
var
	DSPartner : TDataSet;
begin
	//ShowMessage(sKey);
	
	DSPartner := QueryClientes;
	if FindField(ClientDataSetMaster, 'ID_PROVEEDORES') then
			DSPartner := QueryProveedores;
	
	if not DSPartner.Locate(sKey, ClientDataSetMaster.FieldByName(sKey).AsString, loCaseInsensitive) then exit;
	
    ClientDataSetMaster.Edit();
	
	/// CUSTOM FIELDS
	FillInDataSet(DSPartner, ClientDataSetMaster, sKey);
	
end;

{procedure SubStock(sValue: string; nCantidad: double; nSigno: integer);
var
	pCDSXML : TClientDataSet;
	fStock : double;
begin
	
	Query.SQL.Text := 'SELECT * FROM PRODUCTOS WHERE ID_PRODUCTOS = ''' + sValue + '''';
	Query.Active := true;
	
	if (not Query.Eof) and (not Query.FieldByName('SinStock').AsBoolean) then
	begin
			pCDSXML := TClientDataSet.Create(nil);
			zGetXMLData(pCDSXML, Query.FieldByName('Stocks').AsString);
			
			while not pCDSXML.Eof do
			begin
				//ShowMessage(pCDSXML.FieldByName('Cod. Producto').AsString);				
				fStock := pCDSXML.FieldByName('Cantidad').AsFloat;
				
				Query.SQL.Text := 'SELECT * FROM PRODUCTOS WHERE ID_PRODUCTOS = ''' + pCDSXML.FieldByName('Cod. Producto').AsString + '''';
				Query.Active := true;
				
				//ShowMessage(Query.SQL.Text);
				
				if not Query.Eof then 
				begin
					Query.Edit();
					Query.FieldByName('Stock').AsFloat := Query.FieldByName('Stock').AsFloat + nSigno * pCDSXML.FieldByName('Cantidad').AsFloat * nCantidad;
					Query.Post();
				end;
						
				pCDSXML.Next();
			end;
			
			pCDSXML.Free;
	end;
	
end;
}


function ProcesarStock(sValues: String):boolean;
var
  bEliminar, bTraspasado: boolean;
  nSigno: integer;
  bmSavePlace: TBookmark;
  nStock: double;
  QueryDetallesInicio: TFDQuery;
  pL: TStringList;
begin
	
	
    bEliminar := false;
    if ClientDataSetMaster.Tag = 3 then bEliminar := true; // ELIMINAR

	pL := TStringList.Create();
	pL.CommaText := sValues;
	
	//ShowMessage(pL.Values['Tabla']);
    
    // TIPO DE STOCK
    Query.SQL.Text := 'SELECT * FROM DOCUMENTOS_TIPOS WHERE Nombre = ''' + pL.Values['Tabla'] + '''';
    Query.Active := true;

	  bTraspasado := (FindField(ClientDataSetMaster, 'Traspasado')=true) and ClientDataSetMaster.FieldByName('Traspasado').AsBoolean;

	  if not Query.FieldByName('Stock').AsBoolean or bTraspasado then   // Si esta traspasado ya se desconto el stock
    begin
        Result := true;
        exit;
    end;

    nSigno := Query.FieldByName('StockSigno').AsInteger;
	
	
	QueryDetallesInicio := TFDQuery.Create(nil);
	QueryDetallesInicio.Connection := QueryConfiguracion.Connection;
	QueryDetallesInicio.SQL.Text := 'SELECT * FROM ' + pL.Values['Tabla'] + '_DATOS WHERE ID_'+ pL.Values['Tabla'] + ' = ''' + pL.Values['Clave'] + '''' ;
	
	QueryDetallesInicio.Active:=true;
		
	// AVISAR DE STOCK
	if (nSigno = -1 ) and (not QueryConfiguracion.FieldByName('NoStockMsg').AsBoolean) and (not bEliminar ) then
	begin
		//ClientDataSetDetalles.DisableControls();

        ClientDataSetDetalles.First();
        while not ClientDataSetDetalles.Eof do
        begin
            if ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString <> '' then
            begin
                Query.SQL.Text := 'SELECT * FROM PRODUCTOS WHERE ID_PRODUCTOS = ''' +
                    ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString + '''';
                Query.Active := true;
				
				

                if not Query.Eof then
				begin
				
					if Query.FieldByName('SinStock').AsBoolean then
					begin
						ClientDataSetDetalles.Next();
						continue;
					end;
					
					nStock := 0;
					if QueryDetallesInicio.Locate('ID_PRODUCTOS', ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString, loCaseInsensitive) then
						nStock := QueryDetallesInicio.FieldByName('Cantidad').AsFloat;

                    nStock := Query.FieldByName('Stock').AsFloat + nStock - ClientDataSetDetalles.FieldByName('Cantidad').AsFloat;
					if ( nStock - Query.FieldByName('StockMinimo').AsFloat < 0 ) then
					begin
						//nSigno := zMsg('No stock', 0, 0 );
						
						Result:=true;
						
					end;
				end;
			end;
			
			ClientDataSetDetalles.Next();
		end;
	end;
	
	if (Result=true) and ( 6 <> zMsg(zLocalize('No hay stock suficiente. Â¿Desea continuar?.'), 0, 0 ) ) then
	begin
		Result := false;
		exit;	
	end;
	
	

	if (ClientDataSetMaster.Tag <> 1) and (nSigno <> 0) then
	begin
		// REPONER TODO EL STOCK INICIAL
        
		QueryDetallesInicio.First();
        while not QueryDetallesInicio.Eof do
        begin
            if QueryDetallesInicio.FieldByName('ID_PRODUCTOS').AsString <> '' then
            begin
                Query.SQL.Text := 'SELECT * FROM PRODUCTOS WHERE ID_PRODUCTOS = ''' +
                    QueryDetallesInicio.FieldByName('ID_PRODUCTOS').AsString + '''';
                Query.Active := true;

                //ShowMessage(pDetallesInicio.FieldByName('Descripcion').AsString);

                if not Query.Eof then
                begin
					if Query.FieldByName('SinStock').AsBoolean then
					begin
						QueryDetallesInicio.Next();
						continue;
					end;

					Query.Edit();

					Query.FieldByName('Stock').AsFloat :=
						Query.FieldByName('Stock').AsFloat +
						nSigno * (-1) * QueryDetallesInicio.FieldByName('Cantidad').AsFloat;

					Query.Post();
					
					//SubStock(Query.FieldByName('ID_PRODUCTOS').AsString, QueryDetallesInicio.FieldByName('Cantidad').AsFloat, nSigno * (-1));

                end;

            end;

          QueryDetallesInicio.Next();
        end;



    // /REPONER TODO EL STOCK
    end;

	
	
    // RESTAR STOCK
    if (nSigno <> 0) and not bEliminar then
    begin
        
       
        ClientDataSetDetalles.DisableControls();

        ClientDataSetDetalles.First();
        while not ClientDataSetDetalles.Eof do
        begin
            if ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString <> '' then
            begin
                Query.SQL.Text := 'SELECT * FROM PRODUCTOS WHERE ID_PRODUCTOS = ''' +
                    ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString + '''';
                Query.Active := true;

                if not Query.Eof then
				begin
					
					if nSigno > 0 then // COMPRAS Actualizar precio de compra desde albranes y facturas
					begin
						Query.Edit();
						Query.FieldByName('PrecioCompra').AsFloat := ClientDataSetDetalles.FieldByName('Precio').AsFloat;
						Query.Post();

					end;
					
					
					if Query.FieldByName('SinStock').AsBoolean then
					begin
					  ClientDataSetDetalles.Next();
									continue;
					end;

					Query.Edit();

					Query.FieldByName('Stock').AsFloat :=
						Query.FieldByName('Stock').AsFloat +
						nSigno * ClientDataSetDetalles.FieldByName('Cantidad').AsFloat;

					Query.Post();
					
					//SubStock(Query.FieldByName('ID_PRODUCTOS').AsString, ClientDataSetDetalles.FieldByName('Cantidad').AsFloat, nSigno);

				end;


            end;
            ClientDataSetDetalles.Next();
        end;

        ClientDataSetDetalles.EnableControls();


    end;


    Result:=true;
end;

function VerificarStock(sValues: String):string;
var
  bEliminar, bTraspasado: boolean;
  nSigno: integer;
  bmSavePlace: TBookmark;
  nStock: double;
  QueryDetallesInicio: TFDQuery;
  pL: TStringList;
begin
	
	
	pL := TStringList.Create();
	pL.CommaText := sValues;
	
		
	QueryDetallesInicio := TFDQuery.Create(nil);
	QueryDetallesInicio.Connection := QueryConfiguracion.Connection;
	QueryDetallesInicio.SQL.Text := 'SELECT * FROM ' + pL.Values['Tabla'] + '_DATOS WHERE ID_'+ pL.Values['Tabla'] + ' = ''' + pL.Values['Clave'] + '''' ;
	
	QueryDetallesInicio.Active:=true;
		

	ClientDataSetDetalles.First();
	while not ClientDataSetDetalles.Eof do
	begin
		if ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString <> '' then
		begin
			Query.SQL.Text := 'SELECT * FROM PRODUCTOS WHERE ID_PRODUCTOS = ''' +
				ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString + '''';
			Query.Active := true;
			
			

			if not Query.Eof then
			begin
			
				if Query.FieldByName('SinStock').AsBoolean then
				begin
					ClientDataSetDetalles.Next();
					continue;
				end;
				
				nStock := 0;
				if QueryDetallesInicio.Locate('ID_PRODUCTOS', ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString, loCaseInsensitive) then
					nStock := QueryDetallesInicio.FieldByName('Cantidad').AsFloat;

				nStock := Query.FieldByName('Stock').AsFloat + nStock - ClientDataSetDetalles.FieldByName('Cantidad').AsFloat;
				if ( nStock < 0 ) then
				begin
					//nSigno := zMsg('No stock', 0, 0 );
					
					Result := Result + Format(
									zLocalize('%s %s => Unidades disponibles: %0.2f, Unidades necesitadas: %0.2f'),								
									[ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString,
									ClientDataSetDetalles.FieldByName('Descripcion').AsString,
									ClientDataSetDetalles.FieldByName('Cantidad').AsFloat + nStock,
                                    ClientDataSetDetalles.FieldByName('Cantidad').AsFloat
									]) + Chr(10);

				end;
			end;
		end;
		
		ClientDataSetDetalles.Next();
	end;
	
	if Result = '' then
		Result := zLocalize('Hay disponibilidad para todos los conceptos.');
		
	zMsg(Result, -1, 0);
								
end;

function CalcularRentabilidad(sValues: String):string;
var
	dCoste, dVenta, nCantidad, dPrecio, dDescuento, dIva: double;
  bmSavePlace: TBookmark;
  nStock: double;
  pL: TStringList;
begin
	
	
	dCoste := 0;
	dVenta := 0;
		
	ClientDataSetDetalles.First();
	while not ClientDataSetDetalles.Eof do
	begin
		nCantidad := ClientDataSetDetalles.FieldByName('Cantidad').AsFloat;
		dPrecio := zRound(ClientDataSetDetalles.FieldByName('Precio').AsFloat, QueryConfiguracion.FieldByName('DecimalesMoneda').AsInteger);
		dDescuento := ClientDataSetDetalles.FieldByName('Descuento').AsFloat;
		dIva := ClientDataSetDetalles.FieldByName('IVA').AsFloat;
		dIva := 0;// no conteplamos IVA
	  
		dVenta := dVenta + zRound(nCantidad * ( dPrecio * (100 - dDescuento ) / 100 ) * ((dIVA/100 + 1)));	
		
		if ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString <> '' then
		begin
			Query.SQL.Text := 'SELECT * FROM PRODUCTOS WHERE ID_PRODUCTOS = ''' +
				ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString + '''';
			Query.Active := true;
									
			if not Query.Eof then
			begin
				dPrecio := zRound(Query.FieldByName('PrecioCompra').AsFloat, QueryConfiguracion.FieldByName('DecimalesMoneda').AsInteger);
				dCoste := dCoste + zRound(nCantidad * ( dPrecio * (100 - dDescuento ) / 100 ) * ((dIVA/100 + 1)));	
			
			end;
		end;
		
		ClientDataSetDetalles.Next();
	end;
	
	if dVenta - dCoste = 0 then
		Result := 'Margen 0 %'
	else
		Result := Format('Margen total: %s' + Chr(10) + 'Margen relativo: %s', 	
		[Format( '%m', [dVenta - dCoste]), 
		FormatFloat('#0.## %', ((dVenta - dCoste)/dVenta) * 100)]);


	zMsg(Result, -1, 0);
								
end;



procedure AvisarPlazos(sValues: String);
var
  dTotalPlazos: double;
begin

	if QueryConfiguracion.FieldByName('AvisoPlazos').AsBoolean then
	begin
		
		dTotalPlazos := 0;
		ClientDataSetPlazos.First();
		while not ClientDataSetPlazos.Eof do
		begin
			dTotalPlazos := dTotalPlazos + ClientDataSetPlazos.FieldByName('Importe').AsFloat;
			ClientDataSetPlazos.Next();
		end;

		if (ClientDataSetMaster.FieldByName('ID_FORMAS_PAGO').AsString <> '') and (abs(ClientDataSetMaster.FieldByName('TOTAL').AsFloat - dTotalPlazos) > 0.02) then
			if 6 = zMsg(zLocalize('El importe del documento no coincide con la suma de vencimientos. Â¿Desea que el sistema genere automÃ¡ticamente los vencimientos?.' ), 0, 0) then
				CalcularPlazos();
				
	end; 
	 

end;

procedure TZDBFormListProductosCloseQuery(Sender: TObject; var CanClose: Boolean);
var
	pFormList: TZDBFormListProductos;
begin
	pFormList:= TZDBFormListProductos(Sender);

	if pFormList.ModalResult <> mrOk then exit;

	ClientDataSetDetalles.Edit;
	ClientDataSetDetalles.FieldByName('ID_PRODUCTOS').AsString := zGetCurrentValue(pFormList, 'ID_PRODUCTOS');
end;

procedure SeleccionarProducto(sValues: String);
var
	pFormList: TZDBFormListProductos;
begin

	
	
	pFormList := TZDBFormListProductos.Create(zGetActiveForm);	
	pFormList.Parent := zGetActiveForm;
	pFormList.OnCloseQuery := 'TZDBFormListProductosCloseQuery';

	pFormList.Show;

	
end;

procedure TZDBFormListClientesCloseQuery(Sender: TObject; var CanClose: Boolean);
var
	pFormList: TZDBFormListClientes;
begin
	pFormList:= TZDBFormListClientes(Sender);

	if pFormList.ModalResult <> mrOk then exit;

	ClientDataSetMaster.Edit;
	ClientDataSetMaster.FieldByName('ID_CLIENTES').AsString := zGetCurrentValue(pFormList, 'ID_CLIENTES');
end;

procedure TZDBFormListProveedoresCloseQuery(Sender: TObject; var CanClose: Boolean);
var
	pFormList: TZDBFormListProveedores;
begin
	pFormList:= TZDBFormListProveedores(Sender);

	if pFormList.ModalResult <> mrOk then exit;

	ClientDataSetMaster.Edit;
	ClientDataSetMaster.FieldByName('ID_PROVEEDORES').AsString := zGetCurrentValue(pFormList, 'ID_PROVEEDORES');
end;



procedure SeleccionarTercero(sValues: String);
var
	pFormListClientes: TZDBFormListClientes;
	pFormListProveedores: TZDBFormListProveedores;	
begin
	if sValues = 'ID_CLIENTES' then
	begin

		pFormListClientes := TZDBFormListClientes.Create(zGetActiveForm);
		pFormListClientes.Parent := zGetActiveForm;
		pFormListClientes.OnCloseQuery := 'TZDBFormListClientesCloseQuery';
		pFormListClientes.Show;
	end
	else
	begin
		pFormListProveedores := TZDBFormListProveedores.Create(zGetActiveForm);
		pFormListProveedores.Parent := zGetActiveForm;
		pFormListProveedores.OnCloseQuery := 'TZDBFormListProveedoresCloseQuery';
		pFormListProveedores.Show;
	end;
	
end;


function DataChange(sValues: String):double;
var
	pL: TStringList;
		dDescuento, dIVA: double;		
		sField, sDataSet: string;
		i: integer;
		pDS: TDataSet;
begin

	if bUpdating then exit;
		bUpdating := true;	
	
	
	pL := TStringList.Create();
	pL.CommaText := sValues;	
	sDataSet:= pL.Values['DataSet'];
	sField:= pL.Values['Field'];	
	pL.Free;
	
	//zAlert(sDataSet, sField);
	
	if sDataSet = 'ClientDataSetDetalles' then
	begin
		if (sField = 'Cantidad') or (sField = 'Precio') or (sField = 'Importe') or (sField = 'IVA') or (sField = 'Descuento') then
			CalcularPrecios(sField);
		if (sField = 'Descripcion' ) or (sField = 'ID_PRODUCTOS') then
			ProductosChange(sField);
						  

	end;
	
	if sDataSet = 'ClientDataSetMaster' then	
	begin 
		if (sField = 'ID_CLIENTES') or (sField = 'ID_PROVEEDORES') or (sField = 'Nombre') then
			ID_PartnerChange(sField);
		if (sField = 'Descuento') then
			CalcularPrecios('');
		if (sField = 'ConIRPF') then
			CalcularPrecios('');			
		if (sField = 'IRPF') then
			CalcularPrecios('');	
		if (sField = 'ConRE') then
			CalcularPrecios('');
		if (sField = 'TotalEntrega') then
		begin
			ClientDataSetMaster.FieldByName('TotalCambio').AsFloat := zRound(ClientDataSetMaster.FieldByName('TotalEntrega').AsFloat - ClientDataSetMaster.FieldByName('TOTAL').AsFloat);
		end;
		if (sField = 'SinIVA') then
		begin
			SinIVA();
			CalcularPrecios('');
		end;
		if (sField = 'Tarifa') then	
		begin
			AplicarTarifa();
			CalcularPrecios('');
		end;
		
		if (sField = 'ID_FORMAS_PAGO') then
			CalcularPlazos();
			
		if (sField = 'Pagado') then		
			DocumentoPagado();					
			
		if (sField = 'ID_COMERCIALES') then		
			AsignarComision();
	end;
	
	if sDataSet = 'ClientDataSetPlazos' then	
	begin
		if (sField = 'Pagado') or (sField = 'Importe') then
			PlazoPagado();			
		
	end;
    
	
	bUpdating := false;

	Result := 0;

end;



function FormCloseQuery(sValues: String):boolean;
begin
	Result := true;
	
	
	
	if FindField(ClientDataSetMaster, 'ID_INGRESOS_PROGRAMADOS') then exit;
	
	AvisarPlazos(sValues);
	
	Result := ProcesarStock(sValues);


end;

function FormShow(sValues: String):boolean;
begin
	
	if FindField(ClientDataSetMaster, 'Deducible') then
		if ClientDataSetMaster.Tag = 1 then
		begin
			ClientDataSetMaster.FieldByName('Deducible').AsFloat := 100;
			ClientDataSetMaster.FieldByName('CuotaDeducible').AsFloat := 100;
		end;
	


end;







begin

end.
